const mongoose = require("mongoose");

const faqSchema = new mongoose.Schema(
  {
    question: {
      type: String,
      required: [true, "An FAQ must have a question"],
      trim: true,
    },
    answer: {
      type: String,
      required: [true, "An FAQ must have an answer"],
      trim: true,
    },
    category: {
      type: String,
      enum: [
        "general",
        "account",
        "payment",
        "courses",
        "technical",
        "certificates",
        "support",
      ],
      default: "general",
    },
    isActive: {
      type: Boolean,
      default: true,
    },
  },
  {
    timestamps: true,
  }
);

module.exports = mongoose.model("FAQ", faqSchema);
